--[[----------------------------------------------------------------------------
	Copyright 2008 João Liborio Cardoso
	All rights reserved
	
	Bongos3 Minimap (original name: Bongos Skinned Map) is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
	Bongos3 Minimap is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License (<http://www.gnu.org/licenses/>) for more details.
	Every lua file included in this addon is part of Bongos3 Minimap and is subject to the same terms as the ones described here
---------------------------------------------------------------------------]]--

local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
BongosMinimap = Bongos:NewModule('Minimap', 'AceConsole-3.0')

local L = LibStub('AceLocale-3.0'):GetLocale('Bongos3-Minimap')


--[[ Startup ]]--

function BongosMinimap:Load()

	local defaults = {
		stickyButtons = true,
		showZoom = true,
		showDay = true,
		showMap = true,
		showNorth = true,
		showMail = true,
		showBattle = true,
		showTracker = true,
		borderColor = {r = 1, g = 1, b = 1, a = 1},
		border = "Blizzard",
		mask = "ROUND",
		point = "TOPRIGHT",
		y = -24.3,
		x = -14,
	}

	local bar, isNew = Bongos.Bar:Create('minimap', defaults, 'BACKGROUND')
	if isNew then
		self.LoadBar(bar)
	end
	
	-------- temporary update --------------------------
	bar.sets.borderColor.a = bar.sets.borderColor.a or 1
	bar.sets.showBorder = nil
	-------------------------
	
	local color = bar.sets.borderColor
	bar:SetBorderColor(color.r, color.g, color.b, color.a)
	
	bar:ToggleNorth(bar.sets.showNorth)
	bar:SetBorderSkin(bar.sets.border)
	bar:SetMask(bar.sets.mask)
	bar:ToggleButtons()
	
	bar:RegisterButtons(
		MiniMapWorldMapButton,
		MinimapZoomOut,
		MinimapZoomIn,
		GameTimeFrame,
		MiniMapMailFrame,
		MiniMapBattlefieldFrame,
		MiniMapTracking,
		MiniMapMeetingStoneFrame,
		MiniMapVoiceChatFrame,
		Bongos.Minimap
	)
	
	self.bar = bar
end

function BongosMinimap:Unload()
	self.bar:Destroy()
end

function BongosMinimap:LoadBar()

	setmetatable(self, {__index = function(s, k) return BongosMinimap[k] or Bongos.Bar[k] end, __tostring = function() return self.name end})
	
	function GetMinimapShape() return self.sets.mask end
	function GetMaxUIPanelsWidth() return UIParent:GetRight() - UIParent:GetAttribute("RIGHT_OFFSET_BUFFER") end
	
	self:Attach(MinimapCluster)
	self:LoadDependencies()
	self:EnableMouse(false)
	
	self.name = "Bongos3-Minimap"	
	self.OriginalClick = Minimap:GetScript("OnMouseUp")
	
	self:CreateBorderTexture("BOTTOMLEFT", 0.5, 1, 0, 0.5)
	self:CreateBorderTexture("BOTTOMRIGHT", 0, 0.5, 0, 0.5)
	self:CreateBorderTexture("TOPRIGHT", 0, 0.5, 0.5, 1)
	self:CreateBorderTexture("TOPLEFT", 0.5, 1, 0.5, 1)
	self:RegisterDefaultSkins()
	
	MinimapCluster:ClearAllPoints()
	MinimapCluster:SetPoint("CENTER", self, "CENTER", -9, -4)
	MinimapBorder:Hide()
	
	Minimap:EnableMouseWheel(true)
	Minimap:SetScript("OnMouseWheel", self.Zoom)
	Minimap:SetScript("OnMouseUp", function() self:OnClick() end)
end


--[[ Handler Events ]]--

function BongosMinimap:Zoom(arg1)
	if (self:GetZoom() + arg1 <= self:GetZoomLevels()) and (self:GetZoom() + arg1 >= 0) then
		self:SetZoom(self:GetZoom() + arg1)
	end
end

function BongosMinimap:OnClick()
	if self.sets.showTracker or arg1 == "LeftButton" then
		self:OriginalClick()
	elseif arg1 == "RightButton" then
		local cy, cx = GetCursorPosition()
		local my, mx = Minimap:GetLeft(), Minimap:GetBottom()
		local scale = Minimap:GetEffectiveScale()
		
		local offset = 170 
		if(cy < 200) then offset = 0 end
		
		ToggleDropDownMenu(1, nil, MiniMapTrackingDropDown, "Minimap", cy / scale - my - offset, cx / scale - mx)
	end
end


--[[ Miscelaneous ]]--

function BongosMinimap:LoadDependencies()
	-- Titan
	if IsAddOnLoaded("Titan") then
		local oTitanMovableFrame_CheckTopFrame = TitanMovableFrame_CheckTopFrame
		TitanMovableFrame_CheckTopFrame = function(frameTop, top, frameName)
			if frameName ~= "MinimapCluster" then
				oTitanMovableFrame_CheckTopFrame(frameTop, top, frameName)
			end
		end
		TitanMovableData["MinimapCluster"] = nil
	end

	-- Group Calendar
	if IsAddOnLoaded("GroupCalendar") then
		GroupCalendarButton:RegisterForDrag("LeftButton")
		GroupCalendarButton:SetScript('OnDragStart', function() GameTimeFrame:GetScript('OnDragStart')() end)
		GroupCalendarButton:SetScript('OnDragStop', function() GameTimeFrame:GetScript('OnDragStop')() end)
	end
end

function BongosMinimap:ToggleNorth(enable)
	if enable then
		MinimapNorthTag:SetAlpha(1)
	else
		MinimapNorthTag:SetAlpha(0)
	end
	self.sets.showNorth = enable
end